$(document).on('change', ':file', function () {
    var input = $(this),
        numFiles = input.get(0).files ? input.get(0).files.length : 1,
        label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
    input.trigger('fileselect', [numFiles, label]);
});


$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];  //get subfolder (if any) that page is running from and page name
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f'){
            framework_id = params[i + 1];
        }
    }

    $(':file').on('fileselect', function (event, numFiles, label) {

        var input = $(this).parents('.input-group').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;

        if (input.length) {
            input.val(log);
        } else {
            if (log) alert(log);
        }

    });
    setTimeout(function () {
        $('.alert').fadeOut('slow');
    }, 5000);


    $(document).on('click', '#importSubmit', function () {
        event.preventDefault();
        show_loading_message();
        $("#importFrm").submit();
    });


    $(document).on('click', '#select_round', function (e) {
        e.preventDefault();
        //load up a table of active participants in that round (with completed status) and a checkbox next to them so the user can choose whether to include them or not - auto checked
        $('#linked_round_id').val(0);
        $('#linked_participants').html("");
        show_lightbox();
    });

    $('#linked_round_id').change(function () {
        //load up a table of active participants in that round (with completed status) and a checkbox next to them so the user can choose whether to include them or not - auto checked
        var round_id = $('#linked_round_id option:selected').val();
        if (round_id > 0) {
            var request = $.ajax({
                url: '/' + subdir + '/participant_round_display/get_participants/f/' + framework_id,
                cache: false,
                data: 'selectedround=' + round_id + '&openroundsonly=0&framework_id=0&orderby=id desc', //not just active rounds, frameworkid=0 means search outside it
                dataType: 'json',
                contentType: 'application/json; charset=utf-8',
                type: 'get'
            });
            request.done(function (output) {
                var list = "";
                if (output.result == 'success') {
                    $.each(output.data, function (key, val) {
                        list = list + '<label class="container">' + val['fname'] + " " + val['lname'] + " (" + val['email'] + ")";
                        list = list + '<input type="checkbox" checked="checked" name="participantid[]" value="' + val['id'] + '">';
                        list = list + '<span class="checkmark"></span></label>';
                    });
                    $('#linked_participants').html(list);

                } else {
                    show_message('Information request failed', 'error');
                }
                $('#linked_participants').html(list);
            });
            request.fail(function (jqXHR, textStatus) {
                show_message('Information request failed: ' + textStatus, 'error');
            });
        }
        else {
            $('#linked_participants').html("");
        }

    });

    // Add participant submit form
    $(document).on('submit', '#form_participant.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_participant.valid() == true) {
            // Send information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_participant').serialize();
            var myParticipants = new Array();
            $("input:checked").each(function () {
                myParticipants.push($(this).val());
            });;
            var json_arr = JSON.stringify(myParticipants);
            var round_id = $('#round_id').val();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');

            var request = $.ajax({
                url: '/' + subdir + '/import_participants/import_linked_participants/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'myParticipants': json_arr}) + '&' + $.param({'round_id': round_id})  + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    hide_loading_message();
                    show_message(output.message, 'success');
                } else {
                    hide_loading_message();
                    show_message(output.message, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

    // On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            fiscal_year: {
                required: true,
                min: 2000,
                max: 2025
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_participant = $('#form_participant');
    form_participant.validate();


    set_email();

    $('#round_id').change(function () {
        set_email();
    });

    function set_email(){

        var id = $('#round_id option:selected').val();

        var request = $.ajax({
            url: '/' + subdir + '/round/get_round/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                if (output.data[0]["dummy_emails"] == 1) {
                    //hide email field, make non-mandatory
                    $('#instructions_email').html('');
                    $('#instructions_mgr_email').html('');
                } else {
                    $('#instructions_email').html('"Email"');
                    $('#instructions_mgr_email').html('"ManagerEmail"');
                }
            } else {
                show_message('Information request failed', 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            show_message('Information request failed: ' + textStatus, 'danger');
        });
    }

    // Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }


    // Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

    // Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }


    // Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

    // Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

    // Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
    // Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
    // Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

    refreshParticipantList();
    function refreshParticipantList() {
        var request = $.ajax({
            url: '/' + subdir + '/participant_round_display/get_participant_list_view/f/' + framework_id,
            cache: false,
            data: 'id=1',
            dataType: 'text',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            $('#participant_list').html(output);
        });
    }



});
