$(document).on('change', ':file', function () {
    var input = $(this),
        numFiles = input.get(0).files ? input.get(0).files.length : 1,
        label = input.val().replace(/\\/g, '/').replace(/.*\//, '');
    input.trigger('fileselect', [numFiles, label]);
});

$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];
    var framework_id = -1;
    var arrayLength = params.length;
    for (var i = 0; i < arrayLength; i++) {
        if (params[i] == 'f') {
            framework_id = params[i + 1];
        }
    }

    /*
     * DATATABLE INITIALISATION
     */
    var table_respondents = $('#table_respondents').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/respondent_round/get_respondent_status_admin/f/' + framework_id,
            "data": function (d) {
                d.activeonly = $('#activeonly option:selected').val();
                d.selectedframeworkid = $('#selectframework option:selected').val();
                d.selectedparticipantid = $('#selectparticipant option:selected').val();
                d.selectedround = $('#drop option:selected').val();
                d.showrejected = $('#showrejected option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "partname"},
            {"data": "name"},
            {"data": "email"},
            {"data": "relationship"},
            {"data": "status"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "order": [],
        "aaSorting": [],
        "lengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "fnDrawCallback": function (oSettings) {
            $('#table_respondents').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        }
    });

    setInterval(function () {
        $('#table_respondents').DataTable().ajax.reload(null, false);
    }, 120000);

//   var t = setInterval( loadRespondentInfo, 120000 );

    /*
     * ERROR HANDLING
     */


    $.fn.dataTable.ext.errMode = 'none';

    $('#table_respondents')
        .on('error.dt', function (e, settings, techNote, message) {
            // console.log( 'An error has been reported by DataTables: ', message );
            show_message("Table information could not refresh as there is a connection issue, you may have lost network connection or been logged out", 'danger');
        })
        .DataTable();

    // On page load: form validation
    jQuery.validator.setDefaults({
        success: 'valid',
        rules: {
            email: {
                required: true,
                email: true
            }
        },
        errorPlacement: function (error, element) {
            error.insertBefore(element);
        },
        highlight: function (element) {
            $(element).parent('.field_container').removeClass('valid').addClass('error');
        },
        unhighlight: function (element) {
            $(element).parent('.field_container').addClass('valid').removeClass('error');
        }
    });
    var form_respondent = $('#form_respondent');
    form_respondent.validate();

    // Hide message
    function hide_message() {
        $('#message').html('').attr('class', '');
        $('#message_container').hide();
    }

    // Show loading message
    function show_loading_message() {
        $('#loading_container').show();
    }

    // Hide loading message
    function hide_loading_message() {
        $('#loading_container').hide();
    }

    // Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768) {
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset);
            yloc = yloc - 40;
            $('.lightbox_container').css('top', yloc + 'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
        $('.lightbox_container').scrollTop(0);
    }

    // Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

    // Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
    // Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
    // Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

    // Hide iPad keyboard
    function hide_ipad_keyboard() {
        document.activeElement.blur();
        $('input').blur();
    }

    // Add participant button
    $(document).on('click', '#add_respondent', function (e) {
        e.preventDefault();
        // Get round info.  should have passed in framework_id as data id
        //show_loading_message();
        var request = $.ajax({
            url: '/' + subdir + '/respondent_round/get_relationships_admin/f/' + framework_id,
            cache: false,
            data: 'frameworkname=' + $("#selectframework option:selected").text() + '&selectedframeworkid=' + $('#selectframework').val(),
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Add Rater for ' + $("#selectparticipant option:selected").text());
                $('#form_respondent button').html('Add Rater  <i class="icon-arrow-right14 position-right"></i>');
                $('#form_respondent').attr('class', 'form add');
                //$('#form_respondent').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_respondent .field_container label.error').hide();
                $('#form_respondent .field_container').removeClass('valid').removeClass('error');
                $('#form_respondent #fname').val('');
                $('#form_respondent #lname').val('');
                $('#form_respondent #email').val('');
                $('#form_respondent #mgr_fname').val('');
                $('#form_respondent #mgr_lname').val('');
                $('#form_respondent #mgr_email').val('');
                $('#form_respondent #activelabel').hide();
                $('#form_respondent #framework').hide();
                $('#form_respondent #framework').val();
                $('#form_respondent #relationship').empty();
                $.each(output.data[0].relationships, function (key, val) {
                    $('#form_respondent #relationship').append($('<option>', {
                        value: val["code"],
                        text: val["value"]
                    }));
                });


                $('#form_respondent #email').addClass('required');
                $('#email').prop('disabled', false);
                $('#disable_email').prop("checked", false);

                hide_loading_message();
                show_lightbox();
                $("#form_respondent #fname").focus();
            } else {
                hide_loading_message();
                show_message('Information request failed', 'warning');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Information request failed: ' + textStatus, 'warning');
        });
    });


    // Add participant submit form
    $(document).on('submit', '#form_respondent.add', function (e) {
        e.preventDefault();
        // Validate form
        if (form_respondent.valid() == true) {
            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var form_data = $('#form_respondent').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/respondent_round/admin_add_participant_respondent/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'selectedframeworkid': $("#selectframework option:selected").val()}) + '&' + $.param({'relationship_name': $("#relationship option:selected").text()}) + '&' + $.param({'csrf_token': csrf_token})
                + '&' + $.param({'participant_id': $('#selectparticipant option:selected').val()}) + '&' + $.param({'round_id': $('#drop option:selected').val()}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_respondents').DataTable().ajax.reload(function () {
                    }, true);
                    hide_loading_message();
                    show_message("Rater added successfully.", 'success');
                    // Reload respondent count
                    //loadRespondentInfo();

                } else {
                    hide_loading_message();
                    show_message(output.message, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Add request failed: ' + textStatus, 'danger');
            });
        }
    });

    // Edit respondent button
    $(document).on('click', '.function_edit a', function (e) {
        e.preventDefault();
        // Get company information from database
        //show_loading_message();
        var id = $(this).data('id');
        var request = $.ajax({
            url: '/' + subdir + '/respondent_round/get_respondent_admin/f/' + framework_id,
            cache: false,
            data: {
                id: id,
                selectedframeworkid: $("#selectframework option:selected").val(),
                selectedround: $('#drop option:selected').val()
            },
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                $('.lightbox_content h2').text('Edit Rater');
                $('#form_respondent button').html('Edit Rater  <i class="icon-arrow-right14 position-right"></i>');
                $('#form_respondent').attr('class', 'form edit');
                $('#form_respondent').attr('data-id', id);
                $('#form_respondent').attr('data-name', output.data[0].fname + ' ' + output.data[0].lname);
                $('#form_respondent .field_container label.error').hide();
                $('#form_respondent .field_container').removeClass('valid').removeClass('error');
                $('#form_respondent #fname').val(output.data[0].fname);
                $('#form_respondent #lname').val(output.data[0].lname);
                $('#form_respondent #email').val(output.data[0].email);
                $('#form_respondent #relationship').empty();
                $.each(output.data[0].relationships, function (key, val) {
                    var isSelected = false;
                    if (val["code"] == output.data[0].type) {
                        isSelected = true;
                    }
                    $('#form_respondent #relationship').append($('<option>', {
                        value: val["code"],
                        text: val["value"],
                        selected: isSelected
                    }));
                });


                if (output.data[0].email == $('#email_marker').val()) {
                    $('#form_respondent #email').removeClass('required');
                    $('#email').prop('disabled', true);
                    $('#disable_email').prop("checked", true);

                } else {
                    $('#form_respondent #email').addClass('required');
                    $('#email').prop('disabled', false);
                    $('#disable_email').prop("checked", false);
                }

                hide_loading_message();
                show_lightbox();
            } else {
                hide_loading_message();
                show_message('Edit request failed', 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            hide_loading_message();
            show_message('Add request failed: ' + textStatus, 'danger');
        });
    });


    // Edit respondent submit form
    $(document).on('submit', '#form_respondent.edit', function (e) {
        e.preventDefault();
        // Validate form
        if (form_respondent.valid() == true) {

            // Send company information to database
            hide_ipad_keyboard();
            hide_lightbox();
            show_loading_message();
            var id = $('#form_respondent').attr('data-id');
            var form_data = $('#form_respondent').serialize();
            var csrf_token = $('meta[name="csrf-token"]').attr('content');
            var request = $.ajax({
                url: '/' + subdir + '/respondent_round/edit_respondent_admin/f/' + framework_id,
                cache: false,
                data: form_data + '&' + $.param({'selectedframeworkid': $("#selectframework option:selected").val()}) + '&' + $.param({'id': id})
                + '&' + $.param({'relationship_name': $("#relationship option:selected").text()}) + '&' + $.param({'csrf_token': csrf_token}),
                dataType: 'json',
                // contentType: 'application/json; charset=utf-8',
                type: 'POST'
            });
            request.done(function (output) {
                if (output.result == 'success') {
                    // Reload datable
                    $('#table_respondents').DataTable().ajax.reload(function () {
                        hide_loading_message();
                        show_message(output.message, 'success');
                    }, false);
                } else {
                    hide_loading_message();
                    show_message(output.message, 'danger');
                }
            });
            request.fail(function (jqXHR, textStatus) {
                hide_loading_message();
                show_message('Edit request failed: ' + textStatus, 'danger');
            });
        }
    });


    // Cancel participant (make round = -1)
    $(document).on('click', '.function_cancel a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var respondent_name = $(this).data('name');
        var participant_name = $(this).data('partname');
        var id = $(this).data('id');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to cancel '" + respondent_name + "' for " + participant_name + "? ")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/respondent_round/admin_cancel_respondent/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            respondent_id: id,
                            name: respondent_name,
                            csrf_token: csrf_token
                        },
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            $('#table_respondents').DataTable().ajax.reload(function () {
                            }, false);
                            show_message("Respondent '" + respondent_name + "' cancelled successfully.", 'success');
                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Cancel request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    // delete participant (make round = -4)
    $(document).on('click', '.function_delete_respondent a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var respondent_name = $(this).data('name');
        var participant_name = $(this).data('partname');
        var id = $(this).data('id');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to delete '" + respondent_name + "' for " + participant_name + "?  This will PERMANENTLY invalidate the link they received.")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/respondent_round/admin_delete_respondent/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            respondent_id: id,
                            name: respondent_name,
                            csrf_token: csrf_token
                        },
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            $('#table_respondents').DataTable().ajax.reload(function () {
                            }, false);
                            show_message("Respondent '" + respondent_name + "' deleted successfully.", 'success');
                        } else {
                            //hide_loading_message();
                            show_message('Delete request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Delete request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    //
    $(document).on('click', '.function_reactivate a', function (e) {
        e.preventDefault();
        $('.ui-tooltip').remove();
        var respondent_name = $(this).data('name');
        var participant_name = $(this).data('partname');
        var id = $(this).data('id');
        var csrf_token = $('meta[name="csrf-token"]').attr('content');

        $.when(confirm_request("Are you sure you want to re-activate '" + respondent_name + "' for " + participant_name + "?  This will re-enable their link and start sending emails again if they are in an active round with an email address.")).then(
            function (result) {
                if (result) {
                    var request = $.ajax({
                        url: '/' + subdir + '/respondent_round/admin_reactivate_respondent/f/' + framework_id,
                        cache: false,
                        dataType: 'json',
                        data: {
                            respondent_id: id,
                            name: respondent_name,
                            csrf_token: csrf_token
                        },
                        // contentType: 'application/json; charset=utf-8',
                        type: 'POST'
                    });
                    request.done(function (output) {
                        if (output.result == 'success') {
                            // Reload datable
                            $('#table_respondents').DataTable().ajax.reload(function () {
                            }, false);
                            show_message("Respondent '" + respondent_name + "' reactivated successfully.", 'success');
                        } else {
                            //hide_loading_message();
                            show_message('Cancel request failed: ' + output['message'], 'danger');
                        }
                    });
                    request.fail(function (jqXHR, textStatus) {
                        hide_loading_message();
                        show_message('Edit request failed: ' + textStatus, 'danger');
                    });
                }
            }
        );
    });

    $('#drop').change(function () {
        $('#selectparticipant option:selected').val(0);
        refreshParticipantList();
        $('#selectparticipant option:selected').val(0);
        // disable
        $('#add_respondent').prop('disabled', true);
        $('#importSubmit').prop('disabled', true);

        //refresh table
        $('#table_respondents').DataTable().ajax.reload(function () {
        }, true);

        //update lightbox to hide or show email depending on round settings
        set_email();
    });


    //set email and instructions on load
    set_email();

    function set_email() {
        var id = $('#drop option:selected').val();

        var request = $.ajax({
            url: '/' + subdir + '/round/get_round/f/' + framework_id,
            cache: false,
            data: 'id=' + id,
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                if (output.data[0]["dummy_emails"] == 1) {
                    //hide email field, make non-mandatory
                    $('#form_respondent #email').removeClass('required');
                    $('#form_respondent #email_row').hide();
                    $('#instructions').html('Please select a .csv file with column headers and the following information: "FirstName","LastName","RaterType". <br/>NOTE: The Rater type must match exactly to one of the following, excluding the quotation marks: ');
                } else {
                    $('#form_respondent #email').addClass('required');
                    $('#form_respondent #email_row').show();
                    $('#instructions').html('Please select a .csv file with column headers and the following information: "FirstName","LastName","Email","RaterType". <br/>NOTE: The Rater type must match exactly to one of the following, excluding the quotation marks: ');
                }
            } else {
                show_message('Information request failed', 'danger');
            }
        });
        request.fail(function (jqXHR, textStatus) {
            show_message('Information request failed: ' + textStatus, 'danger');
        });
    }

    $('#disable_email').change(function () {
        set_disable_email();
    });

    function set_disable_email() {
        if ($('#disable_email').is(':checked')) {
            $('#form_respondent #email').removeClass('required');
            $('#form_respondent #email').val($('#email_marker').val());
            $('#email').prop('disabled', true);
        } else {
            $('#form_respondent #email').addClass('required');
            $('#form_respondent #email').val('');
            $('#email').prop('disabled', false);
        }
    }

    $('#activeonly').change(function () {
        $('#table_respondents').DataTable().ajax.reload(null, true);
    });

    $('#showrejected').change(function () {
        $('#table_respondents').DataTable().ajax.reload(null, true);
    });

    if ($('#selectparticipant option:selected').val() > 0) {
        $('#add_respondent').prop('disabled', false);
        $('#importSubmit').prop('disabled', false);
    } else {
        $('#add_respondent').prop('disabled', true);
        $('#importSubmit').prop('disabled', true);
    }

    $('#selectparticipant').change(function () {
        if ($('#selectparticipant option:selected').val() > 0) {
            $('#add_respondent').prop('disabled', false);
            $('#importSubmit').prop('disabled', false);
            $('#participant_warning').html('');
        } else {
            $('#add_respondent').prop('disabled', true);
            $('#importSubmit').prop('disabled', true);
            $('#participant_warning').html('<i><b>Please select a participant above before importing raters</b></i>');
        }
        $('#table_respondents').DataTable().ajax.reload(null, true);
        $('#participant_id').val($('#selectparticipant option:selected').val());

        //loadRespondentInfo();
    });

    //hide search option for yes/no drop downs
    $('#drop').select2({
        minimumResultsForSearch: 5
    });
    $('#selectparticipant').select2({
        minimumResultsForSearch: 5
    });
    //focus loop for lightbox
    $("body").on('#form_respondent select2:close', function (e) {
        $('#rater_submit').focus();
    });
    $("#rater_submit").on('blur', function (e) {
        $('#fname').focus();
    });

    function refreshParticipantList() {
        var round = $('#drop option:selected').val();
        var request = $.ajax({
            url: '/' + subdir + '/participant_round_display/get_participants/f/' + framework_id,
            data: 'selectedround=' + round + '&openroundsonly=0',
            dataType: 'json',
            contentType: 'application/json; charset=utf-8',
            type: 'get'
        });
        request.done(function (output) {
            if (output.result == 'success') {
                var html = "<option value=\"0\" selected=\"selected\">Select Participant</option>";
                $.each(output.data, function (key, val) {
                    html += "<option value=" + val["id"] + ">" + val["fname"] + " " + val["lname"] + "</option>";

                });
                $('#selectparticipant').html(html);

            } else {
                // show_message('Information request failed', 'warning');
            }
        });
    }


    $(':file').on('fileselect', function (event, numFiles, label) {

        var input = $(this).parents('.input-group').find(':text'),
            log = numFiles > 1 ? numFiles + ' files selected' : label;

        if (input.length) {
            input.val(log);
        } else {
            if (log) alert(log);
        }
    });
    setTimeout(function () {
        $('.alert').fadeOut('slow');
    }, 5000);

});
