$(document).ready(function() {
  var params = window.location.pathname.split("/");
  var subdir = params[1];
  var dir = params[1] + "/" + params[2]; //get subfolder (if any) that page is running from and page name
  var count_errors = 0;
  var framework_type = $("#framework_type").val();
  var framework_id = -1;
  var arrayLength = params.length;
  for (var i = 0; i < arrayLength; i++) {
    if (params[i] == "f") {
      framework_id = params[i + 1];
    }
  }


  // On page load: datatable

  if (framework_type != "FT8") {
    var table_rounds = $("#table_rounds").DataTable({
      ajax: {
        type: "POST",
        // "url"    : '/' + dir + '/js/job/get_rounds/',
        url: "/" + subdir + "/round/get_rounds/f/" + framework_id,
        data: function(d) {
          d.openroundsonly = $("#openroundsonly option:selected").val(); // $('#activeonlyyes').is(':checked');
          d.selectedround = 0; //all
          d.framework_type = framework_type;
          d.csrf_token = $('meta[name="csrf-token"]').attr("content");
        }
      },
      fnDrawCallback: function(oSettings) {
        $("#table_rounds")
          .DataTable()
          .rows(":not(.parent)")
          .nodes()
          .to$()
          .find("td:first-child")
          .trigger("click");
      },
      columns: [
        { data: "id" },
        { data: "name" },
        { data: "startdate" },
        { data: "enddate" },
        { data: "adminemail" },
        { data: "bccemail" },
        { data: "functions", sClass: "functions" }
      ],
      buttons: [
        {
          extend: "copy",
          exportOptions: {
            columns: ":visible"
          }
        },
        {
          extend: "print",
          exportOptions: {
            columns: ":visible"
          }
        },
        {
          extend: "excel",
          exportOptions: {
            columns: ":visible"
          }
        }
      ],
      aoColumnDefs: [
        { bSortable: false, aTargets: [-1] },
        {
          aTargets: [0],
          bVisible: false,
          bSearchable: false
        }
      ],
      order: [],
      aaSorting: [],
      lengthMenu: [
        [10, 25, 50, 100, -1],
        [10, 25, 50, 100, "All"]
      ],
      oLanguage: {
        oPaginate: {
          sFirst: " ",
          sPrevious: " ",
          sNext: " ",
          sLast: " "
        },
        sLengthMenu: "Records per page: _MENU_",
        sInfo: "Total of _TOTAL_ records (showing _START_ to _END_)",
        sInfoFiltered: "(filtered from _MAX_ total records)"
      },
      initComplete: function(settings, json) {
        table_rounds
          .buttons()
          .container()
          .insertBefore("#table_rounds_info");
        table_rounds
          .buttons()
          .container()
          .css("float", "right");
      }
    });
  } else {
    var table_rounds = $("#table_rounds").DataTable({
      ajax: {
        type: "POST",
        // "url"    : '/' + dir + '/js/job/get_rounds/',
        url: "/" + subdir + "/round/get_rounds/f/" + framework_id,
        data: function(d) {
          d.openroundsonly = $("#openroundsonly option:selected").val(); // $('#activeonlyyes').is(':checked');
          d.selectedround = 0; //all
          d.framework_type = framework_type;
          d.csrf_token = $('meta[name="csrf-token"]').attr("content");
        }
      },
      fnDrawCallback: function(oSettings) {
        $("#table_rounds")
          .DataTable()
          .rows(":not(.parent)")
          .nodes()
          .to$()
          .find("td:first-child")
          .trigger("click");
      },
      columns: [
        { data: "id" },
        { data: "name" },
        { data: "startdate" },
        { data: "enddate" },
        { data: "functions", sClass: "functions" }
      ],
      buttons: [
        {
          extend: "copy",
          exportOptions: {
            columns: ":visible"
          }
        },
        {
          extend: "print",
          exportOptions: {
            columns: ":visible"
          }
        },
        {
          extend: "excel",
          exportOptions: {
            columns: ":visible"
          }
        }
      ],
      aoColumnDefs: [
        { bSortable: false, aTargets: [-1] },
        {
          aTargets: [0],
          bVisible: false,
          bSearchable: false
        }
      ],
      order: [],
      aaSorting: [],
      lengthMenu: [
        [10, 25, 50, 100, -1],
        [10, 25, 50, 100, "All"]
      ],
      oLanguage: {
        oPaginate: {
          sFirst: " ",
          sPrevious: " ",
          sNext: " ",
          sLast: " "
        },
        sLengthMenu: "Records per page: _MENU_",
        sInfo: "Total of _TOTAL_ records (showing _START_ to _END_)",
        sInfoFiltered: "(filtered from _MAX_ total records)"
      },
      initComplete: function(settings, json) {
        table_rounds
          .buttons()
          .container()
          .insertBefore("#table_rounds_info");
        table_rounds
          .buttons()
          .container()
          .css("float", "right");
      }
    });
  }
  

  /*
   * ERROR HANDLING
   */

  $.fn.dataTable.ext.errMode = "none";

  $("#table_rounds")
    .on("error.dt", function(e, settings, techNote, message) {
      console.log("An error has been reported by DataTables: ", message);
    })
    .DataTable();

  // On page load: form validation
  jQuery.validator.setDefaults({
    success: "valid",
    rules: {
      start_date: {
        myDate: true
      },
      end_date: {
        myDate: true
      },
      // report_date: {
      //     myDate: true
      // },
      part_rem1_start_date: {
        myDate: true
      },
      part_rem2_start_date: {
        myDate: true
      },
      resp_rem_start_date: {
        myDate: true
      },
      part_end_date1_display: {
        myDate: true
      },
      part_end_date2_display: {
        myDate: true
      },
      resp_end_date_display: {
        myDate: true
      },
      remind_interval: {
        minHours: 24
      },
      part_remind_interval: {
        minHours: 24
      },
      resp_remind_interval: {
        minHoursOrNone: 24
      },
      mgr_remind_interval: {
        minHoursOrNone: 24
      },
      nom_remind_interval: {
        minHoursOrNone: 24
      }
    },
    errorPlacement: function(error, element) {
      error.insertBefore(element);
    },
    highlight: function(element) {
      $(element)
        .parent(".field_container")
        .removeClass("valid")
        .addClass("error");
    },
    unhighlight: function(element) {
      $(element)
        .parent(".field_container")
        .addClass("valid")
        .removeClass("error");
    }
  });
  $.validator.addMethod(
    "myDate",
    function(value, element) {
      // put your own logic here, this is just a (crappy) example
      return value.match(/^\d\d\d\d?\-\d\d?\-\d\d$/);
    },
    "Please enter a date in the format yyyy-mm-dd."
  );
  $.validator.addMethod(
    "minHours",
    function(value, elementm, param) {
      // put your own logic here, this is just a (crappy) example
      return value >= param;
    },
    "Please enter a number of hours greater than 24"
  );
  $.validator.addMethod(
    "minHoursOrNone",
    function(value, elementm, param) {
      // put your own logic here, this is just a (crappy) example
      var valid = false;
      if (value == "" || value >= param) {
        return true;
      } else {
        return false;
      }
    },
    "Please leave blank or enter a number of hours greater than 24"
  );
  var form_round = $("#form_round");
  form_round.validate();

  //datepicker
  $(function() {
    // $( "#datepicker" ).datepicker();
    $(".datepicker")
      .datepicker({
        dateFormat: "yy-mm-dd",
        changeMonth: true,
        changeYear: true
      })
      .on("change", function(ev) {
        $(this).valid(); // triggers the validation test
      });
  });

  //make datepicker fields readonly
  $(".datepicker").attr("readonly", true);

  // Hide message
  function hide_message() {
    $("#message")
      .html("")
      .attr("class", "");
    $("#message_container").hide();
  }

  // Show loading message
  function show_loading_message() {
    $("#loading_container").show();
  }

  // Hide loading message
  function hide_loading_message() {
    $("#loading_container").hide();
  }

  // Show lightbox
  function show_lightbox() {
    if (window.innerWidth < 768) {
      var yloc =
        navigator.appName === "Microsoft Internet Explorer"
          ? document.documentElement.scrollTop
          : window.pageYOffset;
      yloc = yloc - 40;
      $(".lightbox_container").css("top", yloc + "px");
    }
    $(".lightbox_container").show();
    $(".lightbox_bg").show();
    $(".lightbox_container").show();
    $(".lightbox_container").scrollTop(0);
  }

  // Hide lightbox
  function hide_lightbox() {
    $(".lightbox_bg").hide();
    $(".lightbox_container").hide();
  }

  // Lightbox background
  $(document).on("click", ".lightbox_bg", function() {
    hide_lightbox();
  });
  // Lightbox close button
  $(document).on("click", ".lightbox_close", function() {
    hide_lightbox();
  });
  // Escape keyboard key
  $(document).keyup(function(e) {
    if (e.keyCode == 27) {
      hide_lightbox();
    }
  });

  // Hide iPad keyboard
  function hide_ipad_keyboard() {
    document.activeElement.blur();
    $("input").blur();
  }

  // Add round button
  $(document).on("click", "#add_round", function(e) {
    e.preventDefault();
    var request = $.ajax({
      // url:          '/' + dir + '/get_rounds/',
      url: "/" + subdir + "/framework/get_framework_admin/f/" + framework_id,
      cache: false,
      data: "id=1",
      dataType: "json",
      contentType: "application/json; charset=utf-8",
      type: "get"
    });
    request.done(function(output) {
      $(".lightbox_content h2").text("Add Round");
      $("#form_round button").html(
        'Add Round <i class="icon-arrow-right14 position-right"></i>'
      );
      $("#form_round").attr("class", "form add");
      $("#form_round .field_container label.error").hide();
      $("#form_round .field_container")
        .removeClass("valid")
        .removeClass("error");
      $("#form_round #round_name").val("");
      $("#form_round #start_date").val("");
      $("#form_round #end_date").val("");
      // $('#form_round #report_date').val('');
      $("#form_round #minimum_respondents").val("");
      $("#form_round #use_dummy_emails").val(0);
      $("#form_round #admin_email").val(output.data["email"]);
      $("#form_round #admin_name").val(output.data["name"]);
      $("#form_round #bounce_email").val(output.data["default_bounce"]);
      $("#form_round #bcc_email").val("");
      $("#form_round #remind_interval").val("");
      $("#form_round #part_rem1_start_date").val("");
      $("#form_round #part_rem2_start_date").val("");
      $("#form_round #resp_rem_start_date").val("");
      $("#form_round #part_rem_start_date").val("");
      $("#form_round #part_end_date1_display").val("");
      $("#form_round #part_end_date2_display").val("");
      $("#form_round #resp_end_date_display").val("");
      $("#form_round #part_end_date_display").val("");
      $("#form_round #mgr_remind_interval").val("");
      $("#form_round #resp_remind_interval").val("");
      $("#form_round #nom_remind_interval").val("");
      $("#mail_settings").show();
      $("#dummy_emails").html(
        '<div class="col-md-6">' +
          '<label for="use_dummy_emails" id="email_label">Disable Emails <br/>(system will not send emails for this round): </label>' +
          '</div><div class="col-md-6">' +
          '<div class="field_container">' +
          '<select id="use_dummy_emails" name="use_dummy_emails">' +
          '<option value="0" selected="selected">No</option>' +
          '<option value="1">Yes</option>' +
          "</select>" +
          "</div>" +
          "</div>"
      );
      $("#use_dummy_emails").prop("disabled", false);
      $("#use_dummy_emails").change(function() {
        update_mail();
      });

      hide_loading_message();
      show_lightbox();
      $("#form_round #round_name").focus();
    });
    request.fail(function(jqXHR, textStatus) {
      hide_loading_message();
      show_message("Information request failed: " + textStatus, "warning");
    });
  });

  // Add round submit form
  $(document).on("submit", "#form_round.add", function(e) {
    e.preventDefault();

    var round_name = $("#round_name").val();
    // Validate form
    if (form_round.valid() == true) {
      // Send company information to database
      hide_ipad_keyboard();
      hide_lightbox();
      show_loading_message();
      var form_data = $("#form_round").serialize();
      var csrf_token = $('meta[name="csrf-token"]').attr("content");
      var request = $.ajax({
        url: "/" + subdir + "/round/add_round/f/" + framework_id,
        cache: false,
        data:
          form_data +
          "&" +
          $.param({ framework_type: framework_type }) +
          "&" +
          $.param({ csrf_token: csrf_token }),
        dataType: "json",
        // contentType: 'application/json; charset=utf-8',
        type: "POST"
      });
      request.done(function(output) {
        if (output.result == "success") {
          // Reload datable
          $("#table_rounds")
            .DataTable()
            .ajax.reload(function() {
              hide_loading_message();
              show_message(
                "Round '" + round_name + "' added successfully.",
                "success"
              );
            }, true);
        } else {
          hide_loading_message();
          show_message("Add request failed", "danger");
        }
      });
      request.fail(function(jqXHR, textStatus) {
        hide_loading_message();
        show_message("Add request failed: " + textStatus, "danger");
      });
    }
  });

  // Edit round button
  $(document).on("click", ".function_edit a", function(e) {
    e.preventDefault();
    $(".ui-tooltip").remove();
    var id = $(this).data("id");
    var request = $.ajax({
      url: "/" + subdir + "/round/get_round/f/" + framework_id,
      cache: false,
      data: "id=" + id + "&framework_type=" + framework_type,
      dataType: "json",
      contentType: "application/json; charset=utf-8",
      type: "get"
    });
    request.done(function(output) {
      if (output.result == "success") {
        $(".lightbox_content h2").text("Edit Round");
        $("#form_round button").html(
          'Edit Round <i class="icon-arrow-right14 position-right"></i>'
        );
        $("#form_round").attr("class", "form edit");
        $("#form_round").attr("data-id", id);
        $("#form_round .field_container label.error").hide();
        $("#form_round .field_container")
          .removeClass("valid")
          .removeClass("error");
        if (
          output.data[0].active_participants > 0 &&
          output.data[0].dummy_emails == 0
        ) {
          $("#email_label").html(
            "Disable Emails <br/><i> ** Cannot be changed - there are active participants in this round **</i>"
          );
          $("#use_dummy_emails").prop("disabled", true);
        } else if (
          output.data[0].active_participants > 0 &&
          output.data[0].dummy_emails == 1
        ) {
          $("#email_label").html(
            "Disable Emails <br/><i> ** Cannot be changed - there are active participants in this round **</i>"
          );
          $("#use_dummy_emails").prop("disabled", true);
        } else if (output.data[0].dummy_emails == 1) {
          $("#email_label").html(
            "Disable Emails <br/>(system will not send emails for this round): "
          );
          $("#use_dummy_emails").prop("disabled", false);
          $("#use_dummy_emails").change(function() {
            update_mail();
          });
        } else if (output.data[0].dummy_emails == 0) {
          $("#email_label").html(
            "Disable Emails <br/>(system will not send emails for this round): "
          );
          $("#use_dummy_emails").prop("disabled", false);
          $("#use_dummy_emails").change(function() {
            update_mail();
          });
        }

        $("#form_round #round_name").val(output.data[0].round_name);
        $("#form_round #start_date").val(output.data[0].start_date);
        $("#form_round #end_date").val(output.data[0].end_date);
        // $('#form_round #report_date').val(output.data[0].report_date);
        $("#form_round #admin_email").val(output.data[0].admin_email);
        $("#form_round #admin_name").val(output.data[0].admin_name);
        $("#form_round #bcc_email").val(output.data[0].bcc_email);
        $("#form_round #bounce_email").val(output.data[0].bounce_email);
        $("#form_round #use_dummy_emails").val(output.data[0].dummy_emails);
        $("#form_round #remind_interval").val(output.data[0].remind_interval);
        $("#form_round #minimum_respondents").val(
          output.data[0].minimum_respondents
        );
        $("#form_round #part_rem_start_date").val(
          output.data[0].part_rem_start_date
        );
        $("#form_round #part_rem1_start_date").val(
          output.data[0].part_rem1_start_date
        );
        $("#form_round #part_rem2_start_date").val(
          output.data[0].part_rem2_start_date
        );
        $("#form_round #resp_rem_start_date").val(
          output.data[0].resp_rem_start_date
        );
        $("#form_round #part_end_date_display").val(
          output.data[0].part_end_date_display
        );
        $("#form_round #part_end_date1_display").val(
          output.data[0].part_end_date1_display
        );
        $("#form_round #part_end_date2_display").val(
          output.data[0].part_end_date2_display
        );
        $("#form_round #resp_end_date_display").val(
          output.data[0].resp_end_date_display
        );
        $("#form_round #mgr_remind_interval").val(
          output.data[0].mgr_remind_interval
        );
        $("#form_round #resp_remind_interval").val(
          output.data[0].resp_remind_interval
        );
        $("#form_round #nom_remind_interval").val(
          output.data[0].nom_remind_interval
        );
        if ($("#use_dummy_emails").val() == 1) {
          $("#mail_settings").hide();
        } else {
          $("#mail_settings").show();
        }

        hide_loading_message();
        show_lightbox();
      } else {
        hide_loading_message();
        show_message("Information request failed", "error");
      }
    });
    request.fail(function(jqXHR, textStatus) {
      hide_loading_message();
      show_message("Information request failed: " + textStatus, "error");
    });
  });

  // Edit round submit form
  $(document).on("submit", "#form_round.edit", function(e) {
    e.preventDefault();
    // Validate form
    if (form_round.valid() == true) {
      hide_ipad_keyboard();
      hide_lightbox();
      show_loading_message();
      //temporarily enable email property so can submit
      $("#use_dummy_emails").prop("disabled", false);
      var id = $("#form_round").attr("data-id");
      var round_name = $("#round_name").val();
      var form_data = $("#form_round").serialize();
      var csrf_token = $('meta[name="csrf-token"]').attr("content");
      var request = $.ajax({
        url: "/" + subdir + "/round/edit_round/f/" + framework_id,
        cache: false,
        data:
          form_data +
          "&" +
          $.param({ id: id }) +
          "&" +
          $.param({ csrf_token: csrf_token }),
        dataType: "json",
        // contentType: 'application/json; charset=utf-8',
        type: "post"
      });
      request.done(function(output) {
        if (output.result == "success") {
          // Reload datable
          $("#table_rounds")
            .DataTable()
            .ajax.reload(function() {
              hide_loading_message();
              show_message(
                "Round '" + round_name + "' edited successfully.",
                "success"
              );
            }, true);
        } else {
          hide_loading_message();
          show_message(output.message, "danger");
        }
      });
      request.fail(function(jqXHR, textStatus) {
        hide_loading_message();
        show_message("Edit request failed: " + textStatus, "danger");
      });
    }
  });

  // Cancel round (make framework_id = -fid)
  $(document).on("click", ".function_cancel a", function(e) {
    e.preventDefault();
    $(".ui-tooltip").remove();
    var round_name = $(this).data("name");
    var id = $(this).data("id");
    var csrf_token = $('meta[name="csrf-token"]').attr("content");

    $.when(
      confirm_request("Are you sure you want to cancel '" + round_name + "'?")
    ).then(function(result) {
      if (result) {
        var request = $.ajax({
          url: "/" + subdir + "/round/cancel_round/f/" + framework_id,
          cache: false,
          dataType: "json",
          data: {
            id: id,
            framework_type: framework_type,
            csrf_token: csrf_token
          },
          // contentType: 'application/json; charset=utf-8',
          type: "POST"
        });
        request.done(function(output) {
          if (output.result == "success") {
            // Reload datable
            $("#table_rounds")
              .DataTable()
              .ajax.reload(function() {
                //hide_loading_message();
                show_message(
                  "Round '" + round_name + "' cancelled successfully.",
                  "success"
                );
              }, true);
          } else {
            //hide_loading_message();
            show_message(
              "Cancel request failed: " + output["message"],
              "danger"
            );
          }
        });
        request.fail(function(jqXHR, textStatus) {
          hide_loading_message();
          show_message("Cancel request failed: " + textStatus, "danger");
        });
      }
    });
  });

  // go to participant status
  $(document).on("click", ".function_round_users a", function(e) {
    e.preventDefault();
    var round_id = $(this).data("id");
    window.location =
      "/" +
      subdir +
      "/participant_round_status/f/" +
      framework_id +
      "/round/" +
      round_id;
  });

  // go to round status
  $(document).on("click", ".function_round_status a", function(e) {
    e.preventDefault();
    var round_id = $(this).data("id");
    window.location =
      "/" +
      subdir +
      "/round_status/f/" +
      framework_id +
      "/round/" +
      round_id;
  });

  //tooltips for tables
  $('[data-toggle="tooltip"]').tooltip({});

  $("#selectedround").change(function() {
    $("#table_rounds")
      .DataTable()
      .ajax.reload(null, true);
  });

  $("#activetype").change(function() {
    $("#table_rounds")
      .DataTable()
      .ajax.reload(null, true);
  });

  $("#showcancelled").change(function() {
    $("#table_rounds")
      .DataTable()
      .ajax.reload(null, true);
  });

  $("#activeonlyno").click(function() {
    $("#table_rounds")
      .DataTable()
      .ajax.reload(null, true);
  });
  $("#activeonlyyes").click(function() {
    $("#table_rounds")
      .DataTable()
      .ajax.reload(null, true);
  });

  //hide search option for yes/no drop downs
  $("#showcancelled").select2({
    minimumResultsForSearch: -1
  });
  $("#activetype").select2({
    minimumResultsForSearch: -1
  });

  $(".select2-selection--single").each(function() {
    $(this).addClass("border-primary text-primary-700");
  });

  $("#openroundsonly").change(function() {
    $("#table_rounds")
      .DataTable()
      .ajax.reload(null, true);
  });

  $("#use_dummy_emails").change(function() {
    update_mail();
  });

  function update_mail() {
    if ($("#use_dummy_emails").val() == 1) {
      $("#mail_settings").hide();
      //fill in dummy values
      if ($("#form_round #remind_interval").val() == "")
        $("#form_round #remind_interval").val(999);
      if ($("#form_round #part_rem_start_date").val() == "")
        $("#form_round #part_rem_start_date").val("2199-01-01");
      if ($("#form_round #part_rem1_start_date").val() == "")
        $("#form_round #part_rem1_start_date").val("2199-01-01");
      if ($("#form_round #part_rem2_start_date").val() == "")
        $("#form_round #part_rem2_start_date").val("2199-01-01");
      if ($("#form_round #resp_rem_start_date").val() == "")
        $("#form_round #resp_rem_start_date").val("2199-01-01");
      if ($("#form_round #part_end_date_display").val() == "")
        $("#form_round #part_end_date_display").val("2199-01-01");
      if ($("#form_round #part_end_date1_display").val() == "")
        $("#form_round #part_end_date1_display").val("2199-01-01");
      if ($("#form_round #part_end_date2_display").val() == "")
        $("#form_round #part_end_date2_display").val("2199-01-01");
      if ($("#form_round #resp_end_date_display").val() == "")
        $("#form_round #resp_end_date_display").val("2199-01-01");
      // if ($('#form_round #mgr_remind_interval').val()=='') $('#form_round #mgr_remind_interval').val(999);
      // if ($('#form_round #resp_remind_interval').val()=='') $('#form_round #resp_remind_interval').val(999);
    } else {
      $("#mail_settings").show();
    }
  }

  if ($("#show_dummy_emails").val() == 1) {
    $("#dummy_emails").show();
  } else {
    $("#dummy_emails").hide();
  }
});
