$(document).ready(function () {
    var params = window.location.pathname.split('/');
    var subdir = params[1];
    var dir = params[1] + '/' + params[2];


    loadActionSummary();

    var table_selfscore_surveys = $('#table_selfscore_surveys').DataTable({
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/user_round/get_self_surveys',
            "data": function (d) {
                d.activetype = $('#activetype option:selected').val(); // $('#activeonlyyes').is(':checked');
                d.selectedround = $('#drop option:selected').val();
                d.showcancelled = $('#showcancelled option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "token"},
            {"data": "survey_name"},
            {"data": "framework_name"},
            {"data": "end_date"},
            {"data": "completed"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0, 1],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[15, 25, 50, 100, -1], [15, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "fnDrawCallback": function ( oSettings ) {
            $('#table_selfscore_surveys').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        }
    });
    setInterval(function () {
        $('#table_selfscore_surveys').DataTable().ajax.reload(null, false);
    }, 120000);

    var table_nomination_surveys = $('#table_nomination_surveys').DataTable({
        //"ajax": "./includes/participantdata.php?job=get_participants",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/user_round/get_nomination_surveys',
            "data": function (d) {
                d.activetype = $('#activetype option:selected').val(); // $('#activeonlyyes').is(':checked');
                d.selectedround = $('#drop option:selected').val();
                d.showcancelled = $('#showcancelled option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "token"},
            {"data": "framework_name"},
            {"data": "end_date"},
            {"data": "num_count"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0, 1],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[15, 25, 50, 100, -1], [15, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "fnDrawCallback": function ( oSettings ) {
            $('#table_nomination_surveys').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        }
    });
    setInterval(function () {
        $('#table_nomination_surveys').DataTable().ajax.reload(null, false);
    }, 120000);


    var table_resp_surveys = $('#table_resp_surveys').DataTable({
        //"ajax": "./includes/participantdata.php?job=get_participants",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/user_round/get_resp_surveys',
            "data": function (d) {
                d.activetype = $('#activetype option:selected').val(); // $('#activeonlyyes').is(':checked');
                d.selectedround = $('#drop option:selected').val();
                d.showcancelled = $('#showcancelled option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "token"},
            {"data": "participant_name"},
            {"data": "survey_name"},
            {"data": "framework_name"},
            {"data": "end_date"},
            {"data": "completed"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0, 1],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[15, 25, 50, 100, -1], [15, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "fnDrawCallback": function ( oSettings ) {
            $('#table_resp_surveys').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        }
    });
    setInterval(function () {
        $('#table_resp_surveys').DataTable().ajax.reload(null, false);
    }, 120000);


    var table_resp_nominations = $('#table_resp_nominations').DataTable({
        //"ajax": "./includes/participantdata.php?job=get_participants",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/user_round/get_nomination_info',
            "data": function (d) {
                d.showcancelled = $('#showcancelled option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "framework_name"},
            {"data": "survey_name"},
            {"data": "manager_name"},
            {"data": "nom_count"},
            {"data": "approved"},
            {"data": "rejected"},
            {"data": "waiting"},
            {"data": "end_date"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[15, 25, 50, 100, -1], [15, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "fnDrawCallback": function ( oSettings ) {
            $('#table_resp_nominations').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        }
    });


    setInterval(function () {
        $('#table_resp_nominations').DataTable().ajax.reload(null, false);
    }, 120000);


    var table_resp_approvals = $('#table_resp_approvals').DataTable({
        //"ajax": "./includes/participantdata.php?job=get_participants",
        'ajax': {
            "type": "POST",
            "url": '/' + subdir + '/user_round/get_approvals_info',
            "data": function (d) {
                d.showcancelled = $('#showcancelled option:selected').val();
                d.csrf_token = $('meta[name="csrf-token"]').attr('content');
            }
        },
        "columns": [
            {"data": "id"},
            {"data": "survey_name"},
            {"data": "participant_name"},
            {"data": "waiting"},
            {"data": "approved"},
            {"data": "rejected"},
            {"data": "end_date"},
            {"data": "functions", "sClass": "functions"}
        ],
        "aoColumnDefs": [
            {"bSortable": false, "aTargets": [-1]},
            {
                "aTargets": [0],
                "bVisible": false,
                "bSearchable": false
            }
        ],
        "lengthMenu": [[15, 25, 50, 100, -1], [15, 25, 50, 100, "All"]],
        "oLanguage": {
            "oPaginate": {
                "sFirst": " ",
                "sPrevious": " ",
                "sNext": " ",
                "sLast": " ",
            },
            "sLengthMenu": "Records per page: _MENU_",
            "sInfo": "Total of _TOTAL_ records (showing _START_ to _END_)",
            "sInfoFiltered": "(filtered from _MAX_ total records)"
        },
        "fnDrawCallback": function ( oSettings ) {
            $('#table_resp_approvals').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        }
    });


    setInterval(function () {
        $('#table_resp_approvals').DataTable().ajax.reload(null, false);
    }, 120000);


    /*
     * ERROR HANDLING
     */


    $.fn.dataTable.ext.errMode = 'none';

    $('#table_selfscore_surveys')
        .on('error.dt', function (e, settings, techNote, message) {
            // console.log( 'An error has been reported by DataTables: ', message );
            show_message("Table information could not refresh due to a connection issue, you may have lost network connection or been logged out", 'danger');
        })
        .DataTable();

    $('#table_resp_surveys')
        .on('error.dt', function (e, settings, techNote, message) {
            show_message("Table information could not refresh due to a connection issue, you may have lost network connection or been logged out", 'danger');
        })
        .DataTable();
    $('#table_resp_nominations')
        .on('error.dt', function (e, settings, techNote, message) {
        })
        .DataTable();
    $('#table_resp_approvals')
        .on('error.dt', function (e, settings, techNote, message) {
            // console.log( 'An error has been reported by DataTables: ', message );
        })
        .DataTable();


    // go to add respondents screen
    $(document).on('click', '#add_respondents_btn', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var framework_id = $(this).data('framework_id');
        if (framework_id > 0) {
            window.location = '/'+subdir+'/add_respondents?framework_id=' + framework_id;
        } else {
            window.location = '/'+subdir+'/add_respondents';
        }
    });

    // go to review respondents screen
    $(document).on('click', '#review_respondents_btn', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var participant_id = $(this).data('participant_id');
        if (typeof participant_id == 'undefined') {
            window.location = '/'+subdir+'/review_respondents';
        } else {
            window.location = '/'+subdir+'/review_respondents?participant_id=' + participant_id;
        }
    });


    //click on respondent survey link!
    $(document).on('click', '#resp_survey_link', function (e) {
        e.preventDefault();
        var sid = $(this).data('sid');
        var token = $(this).data('token');
        var url = $(this).data('url');
        window.open(url, '_blank');
        // window.location='surveys.php?url=' + url;
    });


    // Show lightbox
    function show_lightbox() {
        if (window.innerWidth < 768){
            var yloc = (navigator.appName === "Microsoft Internet Explorer") ? (document.documentElement.scrollTop) : (window.pageYOffset) ;
            yloc = yloc - 40;
            $('.lightbox_container').css('top',yloc+'px');
        }
        $('.lightbox_container').show();
        $('.lightbox_bg').show();
        $('.lightbox_container').show();
    }

    // Hide lightbox
    function hide_lightbox() {
        $('.lightbox_bg').hide();
        $('.lightbox_container').hide();
    }

    // Lightbox background
    $(document).on('click', '.lightbox_bg', function () {
        hide_lightbox();
    });
    // Lightbox close button
    $(document).on('click', '.lightbox_close', function () {
        hide_lightbox();
    });
    // Escape keyboard key
    $(document).keyup(function (e) {
        if (e.keyCode == 27) {
            hide_lightbox();
        }
    });

    function loadActionSummary() {
        $.ajax({
            url: '/' + subdir + '/user_round/get_actions_required',
            data: {'csrf_token': $('meta[name="csrf-token"]').attr('content')},
            dataType: 'html',
            type: "POST",
            success: function (info) {
                if (info.indexOf('Login') == -1){
                    $('#actionsummary').html(info);
                } else {
                    window.location = '/'+subdir+'/login';
                }
            }
        });
    }

    $("#warning_message").dialog({
        resizable: false,
        autoOpen: false,
        height: 220,
        width: 520,
        modal: true,
    });

    function logBrowserInfo() {

        var nVer = navigator.appVersion;
        var nAgt = navigator.userAgent;
        var browserName = navigator.appName;
        var fullVersion = '' + parseFloat(navigator.appVersion);
        var majorVersion = parseInt(navigator.appVersion, 10);
        var nameOffset, verOffset, ix;

        // In Opera, the true version is after "Opera" or after "Version"
        if ((verOffset = nAgt.indexOf("Opera")) != -1) {
            browserName = "Opera";
            fullVersion = nAgt.substring(verOffset + 6);
            if ((verOffset = nAgt.indexOf("Version")) != -1)
                fullVersion = nAgt.substring(verOffset + 8);
        }
        // In MSIE, the true version is after "MSIE" in userAgent
        else if ((verOffset = nAgt.indexOf("MSIE")) != -1) {
            browserName = "Microsoft Internet Explorer";
            fullVersion = nAgt.substring(verOffset + 5);
        }
        // In Chrome, the true version is after "Chrome"
        else if ((verOffset = nAgt.indexOf("Chrome")) != -1) {
            browserName = "Chrome";
            fullVersion = nAgt.substring(verOffset + 7);
        }
        // In Safari, the true version is after "Safari" or after "Version"
        else if ((verOffset = nAgt.indexOf("Safari")) != -1) {
            browserName = "Safari";
            fullVersion = nAgt.substring(verOffset + 7);
            if ((verOffset = nAgt.indexOf("Version")) != -1)
                fullVersion = nAgt.substring(verOffset + 8);
        }
        // In Firefox, the true version is after "Firefox"
        else if ((verOffset = nAgt.indexOf("Firefox")) != -1) {
            browserName = "Firefox";
            fullVersion = nAgt.substring(verOffset + 8);
        }
        // In most other browsers, "name/version" is at the end of userAgent
        else if ((nameOffset = nAgt.lastIndexOf(' ') + 1) <
            (verOffset = nAgt.lastIndexOf('/'))) {
            browserName = nAgt.substring(nameOffset, verOffset);
            fullVersion = nAgt.substring(verOffset + 1);
            if (browserName.toLowerCase() == browserName.toUpperCase()) {
                browserName = navigator.appName;
            }
        }
        // trim the fullVersion string at semicolon/space if present
        if ((ix = fullVersion.indexOf(";")) != -1)
            fullVersion = fullVersion.substring(0, ix);
        if ((ix = fullVersion.indexOf(" ")) != -1)
            fullVersion = fullVersion.substring(0, ix);

        majorVersion = parseInt('' + fullVersion, 10);
        if (isNaN(majorVersion)) {
            fullVersion = '' + parseFloat(navigator.appVersion);
            majorVersion = parseInt(navigator.appVersion, 10);
        }


        var info = ''
            + 'Browser name = ' + browserName + ', '
            + 'Full version = ' + fullVersion + ', '
            + 'Major version = ' + majorVersion + ', '
            + 'navigator.appName = ' + navigator.appName + '\n'
            + 'navigator.userAgent = ' + navigator.userAgent;

        // send to php script to log
        $.ajax({
            url: '/' + subdir + '/user_round/get_user_browser',
            data: {info:info},
            dataType: 'html',
            type: "GET",
            success: function (output) {
                //
            }
        });

    }


    // Handle click on "Expand All" button
    $('#btn-show-all-children').on('click', function(){
        // Expand row details
        // table.rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        $('#table_selfscore_surveys').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
        $('#table_nomination_surveys').DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
    });

    // Handle click on "Collapse All" button
    $('#btn-hide-all-children').on('click', function(){
        // // Collapse row details
        // table.rows('.parent').nodes().to$().find('td:first-child').trigger('click');
        $('#table_selfscore_surveys').DataTable().rows('.parent').nodes().to$().find('td:first-child').trigger('click');
        $('#table_nomination_surveys').DataTable().rows('.parent').nodes().to$().find('td:first-child').trigger('click');
    });

    var t = setInterval(loadActionSummary, 120000);


    /**
     * expand the passed datatable
     * @param table
     */
    function expandTable(table){
        table.DataTable().rows(':not(.parent)').nodes().to$().find('td:first-child').trigger('click');
    }

    $('#table_nomination_surveys').on('responsive-resize.dt', function ( e, datatable, columns ) {
        expandTable($('#table_nomination_surveys'));

        // var count = columns.reduce( function (a,b) {
        //     return b === false ? a+1 : a;
        // }, 0 );
        // console.log( count +' column(s) are hidden' );
    });
    $('#table_selfscore_surveys').on('responsive-resize.dt', function ( e, datatable, columns ) {
        expandTable($('#table_selfscore_surveys'));
    });
    $('#table_resp_surveys').on('responsive-resize.dt', function ( e, datatable, columns ) {
        expandTable($('#table_resp_surveys'));
    });
    $('#table_resp_nominations').on('responsive-resize.dt', function ( e, datatable, columns ) {
        expandTable($('#table_resp_nominations'));
    });
    $('#table_resp_approvals').on('responsive-resize.dt', function ( e, datatable, columns ) {
        expandTable($('#table_resp_approvals'));
    });
});
